<?php

   use Illuminate\Database\Migrations\Migration;
   use Illuminate\Database\Schema\Blueprint;
   use Illuminate\Support\Facades\Schema;

   class AddPaymentIdToUserCoursesTable extends Migration
   {
       public function up()
       {
           Schema::table('user_courses', function (Blueprint $table) {
               if (!Schema::hasColumn('user_courses', 'Payment_id')) {
                   $table->unsignedBigInteger('Payment_id')->after('Course_id');
                   $table->foreign('Payment_id')->references('Payment_id')->on('payments')->onDelete('cascade');
               }
           });
       }

       public function down()
       {
           Schema::table('user_courses', function (Blueprint $table) {
               $table->dropForeign(['Payment_id']);
               $table->dropColumn('Payment_id');
           });
       }
   }
